
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_WINDOW_H_
#define _NEUROSIS_ENGINE_WINDOW_H_

/***************************************************************************/

#include <vfw.h>
#include <gdiplus.h>
using namespace Gdiplus;

/***************************************************************************/

class CNeurosisWindow {
	public:
		CNeurosisWindow(float zNear, float zFar, char *engineLogFilename = NULL);
		//! Constructor/Deconstructor
		~CNeurosisWindow();

		//! Call before Font_... calls
		void		Font_Begin(int iTexture);
		//! Call after Font_... calls
		void		Font_End();
		//! Loads position of font values (list from [0..127] with 5 integers per line ... ASCII# x1 x2 y1 y2)
		bool		Font_List_Load(char *filename);
		//! Print out string - x/y positioning based on percentage of screen - (0,0 == bottom left)
		void		Font_List_Print(float x, float y, float size, float r, float g, float b, bool alignCenter, bool alignRight, const char *fmt, ...);
		//! Print out string - x/y positioning based on percentage of screen - (0,0 == bottom left)
		void		Font_String(float x, float y, float size, float r, float g, float b, bool centerText, const char *fmt, ...);
		//! Get mPreviousTexture value
		int			Get_Previous_Texture();
		//! Get mTotalTextures value
		int			Get_Total_Textures();
		//! Cleanup OpenGL
		void		GL_Cleanup();
		//! Create OpenGL window
		bool		GL_Create_Window(char *title, int width, int height, int bits, bool fullscreen, bool allowResize, bool centerWindow, bool showCursor);
		//! Initialize OpenGL - not needed unless not calling GL_Create_Window(...) - such as when using MFC 
		void		GL_Initialize();
		//! Sets the frustum (perspective)
		void		GL_Perspective(float field_of_view, float aspect);
		//! Get mouse coordinates in respect to the current window
		POINT		Mouse_Coordinates();
		//! Process window messages
		void		Process_Messages();
		//! Draws triangle to screen (if not textured, set iTexture = -1)
		void		Render_Triangle(int iTexture, float r, float g, float b, float transparency, float bottomLeftX, float bottomLeftY, float bottomLeftZ, float topRightX, float topRightY, float topRightZ, float topLeftX, float topLeftY, float topLeftZ, float bottomLeftPercentX = 0.0f, float bottomLeftPercentY = 0.0f, float topRightPercentX = 1.0f, float topRightPercentY = 1.0f, float topLeftPercentX = 0.0f, float topLeftPercentY = 1.0f);
		//! Draws quad to screen (if not textured, set iTexture = -1)
		void		Render_Quad(int iTexture, float r, float g, float b, float transparency, float bottomLeftX, float bottomLeftY, float bottomLeftZ, float bottomRightX, float bottomRightY, float bottomRightZ, float topRightX, float topRightY, float topRightZ, float topLeftX, float topLeftY, float topLeftZ, float bottomLeftPercentX = 0.0f, float bottomLeftPercentY = 0.0f, float bottomRightPercentX = 1.0f, float bottomRightPercentY = 0.0f, float topRightPercentX = 1.0f, float topRightPercentY = 1.0f, float topLeftPercentX = 0.0f, float topLeftPercentY = 1.0f);
		//! Resize window
		void		Resize_Window(int width, int height);
		//! Save screenshot of desktop or application (as .png) - can also set start/end coordinates values of the screen to capture
		void		Screenshot_Capture(char *filename, bool isDesktop, int customX = 0, int customY = 0, int customWidth = 0, int customHeight = 0);
		//! Set mPreviousTexture value [0..mTotalTextures-1]
		void		Set_Previous_Texture(int iTexture);
		//! Set the title of the main window
		void		Set_Window_Title(char *title);
		//! Get texture data
		GLuint	Texture_Get_Data(int index);
		//! Get texture filename
		char*		Texture_Get_Name(int index);
		//! Load texture (will overwrite specific texture if index is given, mask color default is black) - returns -1 if it fails
		int			Texture_Load(char *filename, int index = -1);
		//! Remove texture
		void		Texture_Remove(int index);
		//! Remove all textures
		void		Texture_Remove_All();
		//! Reload all textures
		void		Textures_Reload();
		//! Capture frame to video
		void		Video_Capture(float timeStep);
		//! Cleanup and close video file
		void		Video_Cleanup();
		//! Initialize video file
		void		Video_Initialize(char *filename, int desiredFPS);

		HDC				hDC;																		// Private GDI device context
		HINSTANCE	hInstance;															// Instance of program
		HWND			hWnd;																		// Window handle

		bool			pKeys[256];															// Keyboard array
		FILE			*pEngineLog;														// Engine information file
		float			pFontList[128][4];											// Font list array

		bool			mActive;																// Whether program is active
		bool			mMinimized;															// Whether program is minimized
		MSG				mMsg;																		// Message structure
		bool			mQuit;																	// Quit program flag
		float			mZFar;																	// Z buffer far boundary
		float			mZNear;																	// Z buffer near boudary
		int				mScreenHeight;													// Screen resolution height
		int				mScreenWidth;														// Screen resolution width

	private:
		struct STexture {
			char					*pFilename;												// Filename of texture
			unsigned int	mTextureID;												// Texture ID
		};

		//! Binds .* file to texture (used by Texture_Load - uses GDI+)
		bool		Build_GDI(char *filename, int index);
		//! Get position of font letter
		float3	Font_String_Get_Percent(int letter);
		//! Receives the MIME type of an encoder and returns the class identifier (CLSID) of that encoder
		int			Get_Encoder_Clsid(const WCHAR *format, CLSID *pClsid);

		HGLRC								hRC;													// Permanent rendering context

		STexture						*pTextures;										// Texture pointer
		PAVIFILE						pVideoFile;										// Video file handle
		PAVISTREAM					pVideoStream;									// Video stream

		bool								mFullscreen;									// Fullscreen flag
		float								mVideoDesiredTimeInterval;		// 1 / desiredFPS from Video_Initialize()
		float								mVideoTimeLapse;							// Used for when to store next video frame
		GdiplusStartupInput	mGdiplusStartupInput;					// GDI+
		int									mPreviousTexture;							// Texture that was last used
		int									mTotalTextures;								// Total textures loaded
		long								mVideoFrame;									// Current video frame
		ULONG_PTR						mGdiplusToken;								// GDI+
};

/***************************************************************************/
#endif